
//Statistical Inference-Continuous Probability Distributions
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//(i)Student t distribution
deff('[f]=fT(t,nu)','f=gamma((nu+1)./2).*(1+t.^2./nu).^(-(nu+1)/2)/(sqrt(%pi*nu)*gamma(nu/2))')
tt=[-4:0.1:4];
ff=fT(tt,6);
figure
xlabel('t');
ylabel('fT(t)');
title('Student t - nu = 6');
plot(tt,ff,'x')

//Probability Calculation
[P,Q] = cdft("PQ",0.4,6)
disp(Q,'Q')
disp(P,'P')

//Inverse CDF Calculation
t = cdft("T",8,0.45,1-0.45)
disp(t,'t')

//Obtaining degrees of freedom
nu = cdft("Df",0.7,0.3,0.8)
disp(nu,'nu')

//Plotting CDF
xx=[-4:0.1:4];
yy=[];
for x=-4:0.1:4, yy=[yy cdft('PQ',x,6)]; end;
figure
xlabel('t');
ylabel('fX(t)');
title('Student t - nu = 6');
plot(xx,yy,'x')


//(ii)Chi-square distribution
xx = [0:0.1:10];
yy = [];
for x=0:0.1:10, yy=[yy cdfchi('PQ',x,4)]; end;
figure
xlabel('t');
ylabel('fX(t)');
title('Chi-square - nu = 4');
plot(xx,yy,'x')

//Probability calculation
[P,Q] = cdfchi("PQ",1,10)
disp(Q,'Q')
disp(P,'P')

[P,Q] = cdfchi("PQ",0.2,10)
disp(Q,'Q')
disp(P,'P')

//Inverse CDF calculation
chi2 = cdfchi("X",4,0.4,0.6)
disp(chi2,'chi2')

//Calculating degrees of freedom
nu = cdfchi("Df",0.4,0.6,2.7)
disp(nu,'nu')

//Plotting CDF
deff('[f]=fC(x,nu)','f=x.^(nu/2-1).*exp(-x./2)/(2.^(nu/2).*gamma(nu./2))')
cc = [0:0.1:30];
ff = fC(cc,10);
figure
xlabel('chi^2');
ylabel('fC(chi^2)');
title('Chi-square - nu = 10');
plot(cc,ff,'x')


//(iii)F distribution
deff('[f]=fF(F,nuN,nuD)','f=gamma((nuN+nuD)./2).*(nuN./nuD).^(nuN./2).*F.^(nuN./2-1)./(gamma(nuN./2).*gamma(nuD./2).*(1+nuN.*F./nuD).^((nuN+nuD)./2))')
xx = [0:0.1:10];
ff = fF(xx,4,6);
figure 
xlabel('F');
ylabel('fF(F)');
title('F distribution- nuNum = 4 - nuDen =6');
plot(xx,ff,'x')

//Probability Calculation
[P,Q] = cdff("PQ",1.2,6,12)
disp(Q,'Q')
disp(P,'P')

//Inverse CDF calculation
F = cdff("F",10,2,0.4,0.6)
disp(F,'F')

//Calculating degrees of freedom
nuNum = cdff('Dfn',5,0.4,0.6,0.8)
disp(nuNum,'nuNum')

//Plotting CDF
xx = [0:0.1:10];
yy = [];
for x=0:0.1:10, yy=[yy cdff('PQ',x,4,6)]; end;
figure 
xlabel('t');
ylabel('fX(t)');
title('F - nuNum = 4 - nuDen =6');
plot(xx,yy,'x')
